<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AuditReport extends Model 
{

    protected $table = 'audit_reports';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('user_id', 'cash_statement_id', 'slug', 'audit_comment', 'status');
    protected $visible = array('user_id', 'cash_statement_id', 'slug', 'audit_comment', 'status');

    public function cashsStatement()
    {
        return $this->belongsTo('App\Models\CashStatement', 'cash_statement_id');
    }

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

}